<?php
if (!defined('ABSPATH')) {
    exit;
}

global $Botoscope;
$items_in_visible_menu = 8;

if (wp_is_mobile()) {
    $items_in_visible_menu = 2;
}

$apps_slugs = Hooks::apply_action('botoscope_panel_tabs', []);
$apps_slugs['taxonomies'] = esc_html__('Taxonomies', 'botoscope');
if (!botoscope_is_no_cart()) {
    $apps_slugs['payment'] = esc_html__('Payment', 'botoscope');
}
$apps_slugs['controls'] = esc_html__('System Controls', 'botoscope');
$apps_slugs['extensions'] = esc_html__('Extensions', 'botoscope');
?>

<div class="botoscope-admin-preloader">
    <div class="cssload-loader">
        <div class="cssload-inner cssload-one"></div>
        <div class="cssload-inner cssload-two"></div>
        <div class="cssload-inner cssload-three"></div>
    </div>
</div>

<div class="wrap nosubsub">
    <div class="botoscope-header">
        <div>
            <h1 class="botoscope-plugin-name">
                <img src="<?php echo BOTOSCOPE_ASSETS_LINK ?>img/logo.webp" alt="logo" style="position: unset" /> Botoscope Business <span>v.<?php echo BOTOSCOPE_VERSION ?></span> <img src="<?php echo BOTOSCOPE_ASSETS_LINK ?>img/dolphin.svg" alt="logo" />
                <span class="botoscope-slogan"><?php esc_html_e('Boost Your Business with Telegram Commerce', 'botoscope') ?></span>
            </h1>
        </div>
    </div>


    <?php
    $allowUrlFopen = filter_var(ini_get('allow_url_fopen'), FILTER_VALIDATE_BOOLEAN);
    $hasCurl = function_exists('curl_init');

    if (!$allowUrlFopen) {
        echo '<div class="notice notice-error"><p>';
        esc_html_e('Error: The PHP setting "allow_url_fopen" is disabled. Please enable it in your hosting configuration to allow Botoscope to make outgoing HTTP requests.', 'botoscope');
        echo '</p></div>';
    }

    if (!$hasCurl) {
        echo '<div class="notice notice-error"><p>';
        esc_html_e('Error: The PHP extension "cURL" is not installed or enabled. Please enable it in your hosting configuration to allow Botoscope to make outgoing HTTP requests.', 'botoscope');
        echo '</p></div>';
    }
    ?>



    <div class="botoscope-tab-top-panel">
        <div>
            <div style="display: none;">
                <?php
                //todo, this is for js dependency, later resolve
                $active_languages = $botoscope->controls->get_active_languages();
                $default_language = $botoscope->controls->get_default_language();

                array_unshift($active_languages, $default_language); //!!

                if ($active_languages) {
                    ?>
                    <div id="botoscope_products_language_selector">
                        <select data-default="<?php echo $default_language ?>">
                            <?php foreach ($botoscope->languages as $key => $title) : ?>

                                <?php
                                if (!in_array($key, $active_languages)) {
                                    continue;
                                }
                                ?>

                                <option value="<?php echo $key ?>"><?php echo $title ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <?php
                }
                ?>
            </div>
        </div>
        <div>
            &nbsp;
        </div>
    </div>


    <div class="botoscope-tabs botoscope-tabs-style-shape" style="position: relative;">

        <nav <?php if (count($apps_slugs) >= $items_in_visible_menu): ?>style="padding-right: 25px;"<?php endif; ?>>
            <ul id="botoscope_menu_manager_menu">
                <?php
                $counter = 0;
                $offset_counter = 1;
                foreach ($apps_slugs as $key => $title) :

                    if ($counter >= $items_in_visible_menu) {
                        $offset_counter++;
                    }

                    if ($Botoscope->no_bot && in_array($key, ['extensions2', 'payment'])) {
                        continue;
                    }
                    ?>

                    <li style="order: <?php echo ($counter + 1) ?>;" data-slug="<?php echo $key ?>" <?php if ($counter++ === 0): ?>class="tab-current"<?php endif; ?> data-offset="<?php echo $offset_counter * 50 ?>">
                        <a href="#botoscope-<?php echo $key ?>" onclick="return botoscope_init_js_intab('tabs-botoscope-<?php echo $key ?>')"><span class="icon-<?php echo apply_filters("botoscope_{$key}_tab_icon", 'database') ?>"></span><?php echo $title ?></a>
                    </li>

                <?php endforeach; ?>

                <?php if ($Botoscope->no_bot): ?>

                    <li style="order: 99;" class="tab-current" data-offset="50">

                        <a href="#" onclick="window.open('https://t.me/botoscope_bot', '_blank')" target="_blank" style="display: inline-block; background: linear-gradient(135deg, #1DA1F2, #0078D7); color:#fff;"><span class="svg_wrap relative" style="display:inline-block;width:30px; line-height: 36px;"><svg viewBox="0 0 315.1 315.1">
                                <path style="fill:#fff" class="st0" d="M303.4,21L5.5,135.9c-7.3,2.8-7.3,13.2,0.1,16L78.2,179l28.1,90.4c1.8,5.8,8.9,7.9,13.6,4.1l40.5-33  c4.2-3.5,10.3-3.6,14.7-0.4l73,53c5,3.7,12.1,0.9,13.4-5.2L315,30.8C316.2,24,309.7,18.5,303.4,21z M246.5,81.1l-117,108.8  c-4.1,3.8-6.8,9-7.5,14.5l-4,29.6c-0.5,3.9-6.1,4.3-7.2,0.5l-15.3-53.9c-1.8-6.1,0.8-12.7,6.2-16.1l141.9-87.4  C246.1,75.6,248.7,79.1,246.5,81.1z"></path>
                                </svg></span>&nbsp;<?php esc_html_e('Connect your shop to Telegram', 'botoscope') ?>
                        </a>

                    </li>

                <?php endif; ?>

            </ul>
        </nav>

        <?php if (count($apps_slugs) >= $items_in_visible_menu): ?>
            <!-- Hamburger button for hidden items -->
            <span class="botoscope_menu_manager_hamburger" id="botoscope_menu_manager_hamburger">☰</span>
        <?php endif; ?>

        <div class="content-wrap">

            <?php
            $counter = 0;
            foreach (array_keys($apps_slugs) as $key) {
                if (isset($botoscope->$key)) {
                    $botoscope->$key->draw_content($counter);
                    $counter++;
                }
            }
            ?>

        </div>


        <template id="woocommerce_product_attributes"><?php echo json_encode($woocommerce_product_attributes, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES) ?></template>
        <template id="botoscope_languages_list"><?php echo json_encode($languages, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES) ?></template>

        <?php if (count($apps_slugs) >= $items_in_visible_menu): ?>
            <script>
                const menuItems = document.querySelectorAll('#botoscope_menu_manager_menu > li:nth-child(n+<?php echo $items_in_visible_menu ?>)');

                menuItems.forEach((item, index) => {
                    const offset = item.dataset.offset ? parseInt(item.dataset.offset, 10) : (index + 1) * 10;
                    item.style.top = `${offset}px`;
                });
                document.addEventListener("DOMContentLoaded", function () {
                    const hamburgerButton = document.querySelector(".botoscope_menu_manager_hamburger");
                    const menu = document.querySelector("#botoscope_menu_manager_menu");
                    const hiddenMenuItems = document.querySelectorAll("#botoscope_menu_manager_menu > li");

                    // Function to toggle the visibility of hidden menu items
                    function toggleMenu() {
                        hiddenMenuItems.forEach(item => {
                            item.classList.toggle("botoscope_menu_manager_show");
                        });
                    }

                    // Hamburger Button Click Handler
                    hamburgerButton.addEventListener("click", (e) => {
                        e.stopPropagation();
                        toggleMenu();
                    });

                    // Document click handler to hide menu when clicked outside
                    document.addEventListener("click", (e) => {
                        if (!menu.contains(e.target) && !hamburgerButton.contains(e.target)) {
                            hiddenMenuItems.forEach(item => item.classList.remove("botoscope_menu_manager_show"));
                        }
                    });

                    // Closing the menu by clicking on the menu items themselves
                    hiddenMenuItems.forEach(item => {
                        item.addEventListener("click", () => {
                            hiddenMenuItems.forEach(i => i.classList.remove("botoscope_menu_manager_show"));
                        });
                    });

    <?php if (wp_is_mobile()): ?>

                        const menuItems = document.querySelectorAll('#botoscope_menu_manager_menu > li');

                        menuItems.forEach((item, index) => {
                            item.addEventListener('click', e => {
                                setTimeout(() => {
                                    const mi = document.querySelectorAll('#botoscope_menu_manager_menu > li:not(.tab-current)');
                                    let offset = 50;
                                    mi.forEach((item, index) => {
                                        item.style.top = `${offset}px`;
                                        offset += 50;
                                    });

                                }, 111);
                            });
                        });

    <?php endif; ?>
                });

            </script>

            <style>
    <?php if (!wp_is_mobile()): ?>
                    #botoscope_menu_manager_menu > li:nth-child(n+<?php echo $items_in_visible_menu ?>){
                        position: absolute;
                        right: 0;
                        top: 0;
                        z-index: 999;
                        display: inline-block;
                        background: #fff;
                        min-width: 300px;
                    }

                    #botoscope_menu_manager_menu > li:nth-child(n+<?php echo $items_in_visible_menu ?>) > a{
                        text-align: left;
                    }

                    #botoscope_menu_manager_menu > li:nth-child(n+<?php echo $items_in_visible_menu ?>) {
                        display: none;
                    }

    <?php else: ?>

                    #botoscope_menu_manager_menu > li:not(.tab-current){
                        position: absolute;
                        right: 0;
                        top: 0;
                        z-index: 999;
                        display: inline-block;
                        background: #fff;
                        min-width: 300px;
                    }

                    #botoscope_menu_manager_menu > li:not(.tab-current) > a{
                        text-align: left;
                    }

                    #botoscope_menu_manager_menu > li:not(.tab-current) {
                        display: none;
                    }

    <?php endif; ?>



            </style>
        <?php endif; ?>



        <?php if ($Botoscope->no_bot): ?>
            <style>
                select.botoscope-lang-selector{
                    display: none !important;
                }
            </style>
        <?php endif; ?>

    </div>

    <div class="transparent-window"></div>

    <input type="hidden" id="botoscope_form_nonce" value="<?php echo esc_attr(wp_create_nonce('botoscope_form_nonce')); ?>">

    <script>
        jQuery('.botoscope-tabs').botoscopeTabs();

        function botoscope_init_js_intab(tab_id) {
            jQuery(document).trigger("do_" + tab_id);
            jQuery(document).trigger("tab_switched", [tab_id]);
            return true;
        }


        document.addEventListener('DOMContentLoaded', () => {
            const isMobile = window.matchMedia('(max-width: 768px)').matches;

            if (isMobile) {
                alert('⚠ ️' + "<?php esc_html_e('The dashboard works best on larger screens. Try opening the site from a laptop, desktop, or tablet — the interface will be more convenient.', 'botoscope') ?>");
            }
        });


    </script>

    <?php
    if (!get_option('botoscope_first_run_completed', false)) :
        update_option('botoscope_first_run_completed', true);
        ?>
        <script>
            alert('⚠️ ' + "<?php esc_html_e('Welcome to Botoscope! 🎉\n\nIMPORTANT FIRST STEP:\n\n1️⃣ Configure wp-config.php with your Botoscope credentials\n2️⃣ Go to System Controls tab\n3️⃣ Click [Full Reset System Data] button\n\nThis will synchronize your Telegram shop with your WordPress site.', 'botoscope') ?>");
        </script>
    <?php endif; ?>

</div>
