<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

//12-08-2025
final class BOTOSCOPE_HELPER {

    public static function render_html_e($pagepath, $data = array()) {

        if (is_array($data) AND !empty($data)) {
            if (isset($data['pagepath'])) {
                unset($data['pagepath']);
            }
            extract($data);
        }

        //***
        include(str_replace(array('/', '\\'), DIRECTORY_SEPARATOR, $pagepath));
    }

    public static function sanitize_array($array) {
        if (is_array($array)) {
            foreach ($array as $key => &$value) {
                if (is_array($value)) {
                    $value = self::sanitize_array($value);
                } else {
                    $value = sanitize_text_field($value);
                }
            }
        }

        return $array;
    }

    public static function compare_assoc_arrays($array1, $array2) {
        $diff1 = array_diff_assoc($array1, $array2);
        $diff2 = array_diff_assoc($array2, $array1);

        if (empty($diff1) && empty($diff2)) {
            return true;
        }

        return false;
    }

    public static function encrypt_value($value, $salt) {
        return hash_hmac('sha256', $value, $salt);
    }

    public static function encrypt_array($data, $salt) {
        $json = json_encode($data);
        return base64_encode($salt . $json);
    }

    public static function woocs_exchange_value($value, $selected_currency) {
        global $WOOCS;
        
        if ($WOOCS && $WOOCS->default_currency !== $selected_currency) {
            $currencies = $WOOCS->get_currencies();
            $value = floatval($value) * floatval($currencies[$selected_currency]['rate']);
            $precision = $WOOCS->get_currency_price_num_decimals($selected_currency, $WOOCS->price_num_decimals);
            $value = number_format($value, $precision, $WOOCS->decimal_sep, '');
        }

        return $value;
    }

    public static function get_product_variation_string($attributes) {
        $attribute_strings = [];
        /*
         * $attributes
          [pa_color] => 18
          [pa_material] => 25
          [pa_size] => 30
         */

        foreach ($attributes as $attribute_name => $attribute_value) {
            $attribute_label = wc_attribute_label($attribute_name);
            $term = get_term($attribute_value);
            $attribute_value_label = $term ? mb_strtolower($term->name) : esc_html__('unknown', 'botoscope');
            $attribute_strings[] = "{$attribute_label}: {$attribute_value_label}";
        }

        return implode(", ", $attribute_strings);
    }

    public static function format_time($time) {
        try {
            if (is_numeric($time)) {
                // Timestamp
                $datetime = new DateTime('@' . intval($time));
            } else {
                $datetime = new DateTime($time);
            }
            $datetime->setTimezone(wp_timezone());
            $format = get_option('date_format') . ' ' . get_option('time_format');
            return $datetime->format($format);
        } catch (Exception $e) {
            return '';
        }
    }

    public static function http_request(string $url, array $opts = []): array {
        $timeout = $opts['timeout'] ?? 8;
        $headers = $opts['headers'] ?? [];
        $method = strtoupper($opts['method'] ?? 'GET');
        $body = $opts['body'] ?? null;

        // 1) file_get_contents
        if (filter_var(ini_get('allow_url_fopen'), FILTER_VALIDATE_BOOLEAN)) {
            $contextOpts = [
                'http' => [
                    'method' => $method,
                    'timeout' => $timeout,
                    'header' => implode("\r\n", array_map(fn($k, $v) => "$k: $v", array_keys($headers), $headers)),
                    'content' => $body ?? '',
                    'ignore_errors' => true, // чтобы получить тело при 4xx/5xx
                ],
            ];
            $ctx = stream_context_create($contextOpts);
            $response = @file_get_contents($url, false, $ctx);
            $code = 0;
            if (isset($http_response_header[0]) && preg_match('~\s(\d{3})\s~', $http_response_header[0], $m)) {
                $code = (int) $m[1];
            }
            if ($response === false) {
                return ['ok' => false, 'code' => $code, 'error' => 'file_get_contents failed', 'body' => null];
            }
            return ['ok' => ($code >= 200 && $code < 300), 'code' => $code, 'error' => null, 'body' => $response];
        }


        // 2) cURL
        if (function_exists('curl_init')) {
            $ch = curl_init($url);
            $curlHeaders = [];
            foreach ($headers as $k => $v) {
                $curlHeaders[] = $k . ': ' . $v;
            }

            curl_setopt_array($ch, [
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_CUSTOMREQUEST => $method,
                CURLOPT_HTTPHEADER => $curlHeaders,
                CURLOPT_CONNECTTIMEOUT => $timeout,
                CURLOPT_TIMEOUT => $timeout,
            ]);

            if ($body !== null) {
                curl_setopt($ch, CURLOPT_POSTFIELDS, $body);
            }

            $response = curl_exec($ch);
            $errno = curl_errno($ch);
            $error = curl_error($ch);
            $code = (int) curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);

            if ($errno) {
                return ['ok' => false, 'code' => 0, 'error' => 'cURL: ' . $error, 'body' => null];
            }

            return ['ok' => ($code >= 200 && $code < 300), 'code' => $code, 'error' => null, 'body' => $response];
        }

        return ['ok' => false, 'code' => 0, 'error' => 'No HTTP transport available (cURL disabled, allow_url_fopen=0).', 'body' => null];
    }
}


