<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
        <title><?php echo esc_html__('Botoscope Support Chat', 'botoscope') ?></title>
        <style>
            body {
                margin: 0;
                font-family: 'Segoe UI', sans-serif;
                background-color: #1e1e2f;
                color: #e5e5e5;
                display: flex;
                flex-direction: column;
                height: 100vh;
            }

            .chat-container {
                flex: 1;
                padding: 15px;
                overflow-y: auto;
                display: flex;
                flex-direction: column;
            }

            .message {
                max-width: 70%;
                padding: 10px 14px;
                border-radius: 16px;
                margin-bottom: 10px;
                word-wrap: break-word;
                line-height: 1.4;
                font-size: 15px;
                position: relative;
            }

            .you {
                align-self: flex-end;
                background-color: #007aff;
                color: white;
                border-bottom-right-radius: 0;
            }

            .customer {
                align-self: flex-start;
                background-color: #2a2f45;
                color: #e5e5e5;
                border-bottom-left-radius: 0;
            }

            .meta {
                font-size: 11px;
                opacity: 0.7;
                margin-top: 6px;
            }

            .input-area {
                display: flex;
                align-items: flex-end;
                padding: 10px;
                border-top: 1px solid #333;
                background-color: #262836;
            }

            .input-area textarea {
                flex: 1;
                resize: none;
                max-height: 150px;
                padding: 10px 14px;
                border-radius: 20px;
                border: none;
                outline: none;
                background-color: #2f3144;
                color: #fff;
                font-size: 14px;
                line-height: 1.4;
                overflow-y: auto;
            }

            .send-button {
                margin-left: 10px;
                background: none;
                border: none;
                cursor: pointer;
                align-self: flex-end;
            }

            .send-button svg {
                width: 24px;
                height: 24px;
                fill: #007aff;
            }

            .send-button:hover svg {
                fill: #339dff;
            }

            /* Добавить в <style> */
            .dropdown-container {
                background-color: #262836;
                border-bottom: 1px solid #333;
            }

            .dropdown-header {
                padding: 12px 16px;
                cursor: pointer;
                font-weight: bold;
                background-color: #2f3144;
                color: #fff;
            }

            .dropdown-content {
                display: none;
                padding: 10px;
                background-color: #1e1e2f;
                border-top: 1px solid #333;
            }

            .client-entry {
                margin-bottom: 8px;
                background-color: #2a2f45;
                padding: 10px;
                border-radius: 10px;
                cursor: pointer;
                color: #e5e5e5;
                position: relative;
            }

            .client-details {
                display: none;
                margin-top: 8px;
                background-color: #333950;
                padding: 10px;
                border-radius: 8px;
            }
        </style>
    </head>
    <body>
        <?php if ($non_answered_tickets): ?>
            <div class="dropdown-container">
                <div class="dropdown-header" onclick="toggleDropdown()">👥 <?php
                    printf(
                            esc_html__('Clients waiting for reply (%d)', 'botoscope'),
                            count($non_answered_tickets)
                    )
                    ?></div>
                <div class="dropdown-content" id="dropdownContent">

                    <?php foreach ($non_answered_tickets as $t) : if (intval($ticket_id) === intval($t['id'])) continue; ?>
                        <div class="client-entry" onclick="toggle_ticket(<?php echo $t['id'] ?>, '<?php echo $t['hash_key'] ?>')">
                            <?php
                            printf(
                                    '🕓 ' . esc_html__('Ticket #%d — waiting for reply', 'botoscope'),
                                    $t['id']
                            )
                            ?>
                        </div>
                    <?php endforeach; ?>

                </div>
                <div style="position: absolute; right: 9px; top: 12px;">
                    #<?php echo $ticket_id ?>
                </div>
            </div>
        <?php endif; ?>

        <div class="chat-container" id="chat">

            <?php if (!empty($messages)): ?>
                <?php foreach ($messages as $m) : ?>

                    <?php $date = BOTOSCOPE_HELPER::format_time($m['time']); ?>

                    <?php if ($m['message_type'] === 'question'): ?>

                        <div class="message customer">
                            <?php echo nl2br($m['content']) ?>
                            <div class="meta"><?php esc_html_e('Customer', 'botoscope') ?> · <?php echo $date ?></div>
                        </div>


                    <?php else: ?>

                        <div class="message you">
                            <?php echo nl2br($m['content']) ?>
                            <div class="meta"><?php esc_html_e('You', 'botoscope') ?> · <?php echo $date ?></div>
                        </div>

                    <?php endif; ?>


                <?php endforeach; ?>
            <?php endif; ?>
        </div>

        <div class="input-area">
            <textarea id="chatInput" placeholder="<?php esc_html_e('Write a message...', 'botoscope') ?>" oninput="autoResize(this)" rows="1"></textarea>
            <button class="send-button" onclick="sendMessage()">
                <svg viewBox="0 0 24 24">
                <path d="M2 21l21-9L2 3v7l15 2-15 2v7z"/>
                </svg>
            </button>
        </div>

        <script>

            var ajaxurl = "<?php echo $ajaxurl ?>";
            var page_url = "<?php echo str_replace('http://', 'https://', get_site_url(null, 'botoscope-chat')); ?>";

            window.addEventListener('load', function () {
                const chat = document.getElementById('chat');
                if (chat) {
                    chat.scrollTop = chat.scrollHeight;
                }
            });
            function sendMessage() {
                const input = document.getElementById('chatInput');
                const message = input.value.trim();
                if (!message) {
                    return;
                }

                const chat = document.getElementById('chat');
                const msgDiv = document.createElement('div');
                msgDiv.className = 'message you';
                const now = new Date();
                const timeString = now.toLocaleString('en-US', {
                    day: '2-digit', month: '2-digit', year: 'numeric',
                    hour: '2-digit', minute: '2-digit'
                });
                msgDiv.innerHTML = `
              ${message.replace(/\n/g, '<br/>')}
              <div class="meta">You · ${timeString}</div>
            `;
                chat.appendChild(msgDiv);
                chat.scrollTop = chat.scrollHeight;
                input.value = '';
                autoResize(input);

                //+++

                ajax('botoscope_business_in_pocket_answer_to_customer', {
                    ticket_id: <?php echo $ticket_id ?>,
                    message
                }, null, false);
            }

            function autoResize(textarea) {
                textarea.style.height = 'auto';
                textarea.style.height = Math.min(textarea.scrollHeight, 100) + 'px';
            }

            function toggleDropdown() {
                const dropdown = document.getElementById('dropdownContent');
                dropdown.style.display = dropdown.style.display === 'block' ? 'none' : 'block';
            }

            function toggle_ticket(ticket_id, hash_key) {
                window.location.href = `${page_url}?botoscope_chat=1&ticket_id=${ticket_id}&hash_key=${hash_key}`;
            }

            async function ajax(action, data, callback = null, json = true, custom_ajaxurl = null, signal = null) {
                function appendFormData(fd, data, parentKey = '') {
                    if (data && typeof data === 'object' && !Array.isArray(data)) {
                        for (let key in data) {
                            const fullKey = parentKey ? `${parentKey}[${key}]` : key;
                            appendFormData(fd, data[key], fullKey);
                        }
                    } else if (Array.isArray(data)) {
                        data.forEach((value, index) => {
                            const fullKey = `${parentKey}[${index}]`;
                            appendFormData(fd, value, fullKey);
                        });
                    } else {
                        fd.append(parentKey, data);
                }
                }

                const fd = new FormData();
                appendFormData(fd, {...{action}, ...data});
                fd.append('botoscope_form_nonce', '<?php echo $nonce ?>');
                const response = await
                        fetch(custom_ajaxurl ? custom_ajaxurl : ajaxurl, {
                            signal: signal,
                            method: 'POST',
                            credentials: 'same-origin',
                            body: fd
                        }
                        );
                const result = json ? await response.json() : await response.text();
                if (callback) {
                    callback(result);
                }

                return result;
            }

        </script>


    </body>
</html>
